;
;								EJEMPLO 22
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El TMR1 en el modo temporizador
;
;Se desea realizar un contador binario visualizado sobre la Puerta B que, se vaya incremen-
;tando a razn de una unidad cada 0.1 segundos. Para ello contamos con la ayuda de la
;interrupcin provocada por el TMR1
		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

			org	0x00				;Vector de RESET	
			goto	Inicio
			org	0x04
			goto	Inter			;Vector de interrupcin

;Programa de tratamiento de interrupcin

Inter		movlw	low ~.12500
			movwf	TMR1L			;Carga la parte de menos peso de 12500 en TMR1L
			movlw	high ~.12500
			movwf	TMR1H			;Repone el TMR1 con el valor 12500.
			bcf		PIR1,TMR1IF		;Desconecta el flag del TMR1
			incf	PORTB,F			;Incrementa el contador de la Puerta B
			retfie

;Programa principal

Inicio		clrf 	PORTB			;Borra los latch de salida
			bsf		STATUS,RP0		;Selecciona banco 1
			clrf	TRISB			;Puerta B se configura como salida
			bsf		PIE1,TMR1IE		;habilita interrupcin del TMR1
			bcf		STATUS,RP0		;Selecciona banco 0

;El TMR1 trabaja con oscilador interno y un preescaler de 1:8. Si se trabaja a una frecuencia
;de 4 MHz, el TMR1 deber ser cargado con 12500 para que provoque interrupcin al de 0.1s
;(12500 * 8 * 1 =100000uS=0.1")

			movlw	low ~.12500
			movwf	TMR1L
			movlw	high ~.12500
			movwf	TMR1H			;Carga el TMR1 con el valor 12500.
			movlw	b'00110001'		;Selecciona reloj interno y preescaler de 8
			movwf	T1CON			;Habilita el TMR1
			movlw	b'11000000'
			movwf	INTCON			;Habilitacin global de interrupciones

Loop		nop
			goto	Loop			;Bucle infinito		

			end						;Fin del programa fuente
